// Score generation software for Duplex Drumming
// Simon Blackmore, May 2019
// The purpose of this file is to generate the scores for Duplex Drumming which used the
// rhythm to text translator based on serial data transmission.
// This code generates a text file that can be opened in Lilypond and compiled
// as a PDF. You will need Lilypond http://lilypond.org/
// It is bit of a multistep process but much much easier than notating the scores by hand!

// First of all we create an array that holds Lilypond notation for each ASCII letter
// or each bar of music.

(
//
a = List[];
for (0, 31, {arg i;
	a.add('x');
});

// add the codes
a.add('r4 r4 r4  tamb4 ^"space"  r8 tamb8 |');
a.add('r8 tamb8 r4 r4  tamb4 r8 tamb8 ^"!" |');
a.add('r4 tamb4 r4  tamb4 r8 tamb8 ^"!" |');
a.add('r8 tamb8 tamb4 r4  tamb4 r8 tamb8 ^"#" |');
a.add('r4 r8  tamb8 r4  tamb8 r4 tamb8 ^"$" |');
a.add('r8 tamb8 r8 tamb8 r4  tamb4 r8 tamb8 ^"%" |');
a.add('r4 tamb8 tamb8  r4  tamb4 r8 tamb8 ^"&" |');
a.add('r8 tamb8 tamb8 tamb8 r4  tamb4 r8 tamb8 ^" p" |');
a.add('r4 r4 tamb4  tamb4 r8 tamb8 ^"c" |');
a.add('r8 tamb8 r4 tamb4  tamb4 r8 tamb8 ^"c" |');
a.add('r4 tamb4 tamb4  tamb4 r8 tamb8 ^"*" |');
a.add('r8 tamb8 tamb4 tamb4  tamb4 r8 tamb8 ^"+" |');
a.add('r4 r8 tamb8 tamb4 tamb4 r8 tamb8 ^"mm" |');
a.add('r8 tamb8 r8 tamb8 tamb4 tamb4 r8 tamb8 ^"-" |');
a.add('r4 tamb8 tamb8 tamb4 tamb4 r8 tamb8 ^"." |');
a.add('r8 tamb8 tamb8 tamb8 tamb4 tamb4 r8 tamb8 ^"." |');
a.add('r4 r4 r8 tamb8 tamb4 r8 tamb8 ^"0" |');
a.add('r8 tamb8 r8 r8  r8 tamb8 tamb4 r8 tamb8 ^"1" |');
a.add('r4 tamb8 r8 r8 tamb8 tamb4 r8 tamb8 ^"2" |');
a.add('r8 tamb8 tamb8 r8 r8 tamb8 tamb4 r8 tamb8 ^"3" |');
a.add('r4 r8 tamb8 r8 tamb8 tamb4 r8 tamb8 ^"4" |');
a.add('r8 tamb8 r8 tamb8 r8 tamb8 tamb4 r8 tamb8 ^"5" |');
a.add('r4 tamb8 tamb8 r8 tamb8 tamb4 r8 tamb8 ^"6" |');
a.add('r8 tamb8 tamb8 tamb8 r8 tamb8 tamb8 r8 r8 tamb8 ^"7" |');
a.add('r4 r4 tamb8 tamb8 tamb8 r8 r8 tamb8 ^"8" |');
a.add('r8 tamb8 r4 tamb8 tamb8 tamb4 r8 tamb8 ^"9" |');
a.add('r4 tamb4 tamb8 tamb8 tamb4 r8 tamb8 ^":" |');
a.add('r8 tamb8 tamb4 tamb8 tamb8 tamb4 r8 tamb8 ^";" |');
a.add('r4 r8 tamb8 tamb8 tamb8 tamb8 r8 r8 tamb8 ^"<" |');
a.add('r8 tamb8 r8 tamb8 tamb8 tamb8 tamb4 r8 tamb8 ^"=" |');
a.add('r4 tamb8 tamb8 tamb8 tamb8 tamb4 r8 tamb8 ^">" |');
a.add('r8 tamb8 tamb8 tamb8 tamb8 tamb8 tamb4 r8 tamb8 ^"?" |');
a.add('r4 r4 r4 r8 tamb8 r8 tamb8 ^"@" |');
a.add('r8 tamb8 r4 r4  r8 tamb8 r8 tamb8 ^"A" |');
a.add('r4 tamb4 r4 r8 tamb8 r8 tamb8 ^"B" |');
a.add('r8 tamb8 tamb4 r4 r8 tamb8 r8 tamb8 ^"C" |');
a.add('r4 r8 tamb8 r4 r8 tamb8  r8 tamb8 ^"D" |');
a.add('r8 tamb8 r8 tamb8 r4  r8 tamb8 r8 tamb8 ^"E" |');
a.add('r4 tamb8 tamb8 r4  r8 tamb8 r8 tamb8 ^"F" |');
a.add('r8 tamb8 tamb8 tamb8  r4 r8 tamb8 r8 tamb8 ^"G" |');
a.add('r4 r4 tamb8 r8 r8 tamb8 r8 tamb8 ^"H" |');
a.add('r8 tamb8 r4 tamb8 r4 tamb8 r8 tamb8 ^"I" |');
a.add('r4 tamb4 tamb8 r4 tamb8 r8 tamb8 ^"J" |');
a.add('r8 tamb8 tamb4 tamb4 r8 tamb8 r8 tamb8 ^"K" |');
a.add('r4 r8 tamb8 tamb4 r8 tamb8 r8 tamb8 ^"L" |');
a.add('r8 tamb8 r8 tamb8 tamb4 r8 tamb8 r8 tamb8 ^"M" |');
a.add('r4 tamb8 tamb8 tamb8 r8 r8 tamb8 r8 tamb8 ^"N" |');
a.add('r8 tamb8 tamb8 tamb8 tamb4 r8 tamb8 r8 tamb8 ^"O" |');
a.add('r4 r4 r8 tamb8 r8 tamb8 r8 tamb8 ^"P" |');
a.add('r8 tamb8 r4 r8 tamb8 r8 tamb8 r8 tamb8 ^"Q" |');
a.add('r4 tamb8 r8 r8 tamb4 tamb8 r8 tamb8 ^"R" |');
a.add('r8 tamb8 tamb4 r8 tamb8 r8 tamb8 r8 tamb8 ^"S" |');
a.add('r4 r8 tamb8 r8 tamb8 r8 tamb8 r8 tamb8 ^"T" |');
a.add('r8 tamb8 r8 tamb8 r8 tamb8 r8 tamb8 r8 tamb8 ^"U" |');
a.add('r4 tamb8 tamb8 r8 tamb8 r8 tamb8 r8 tamb8 ^"V" |');
a.add('r8 tamb8 tamb8 tamb8 r8 tamb8 r8 tamb8 r8 tamb8 ^"W" |');
a.add('r4 r4 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"X" |');
a.add('r8 tamb8 r4 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"Y" |');
a.add('r4 tamb4 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"Z" |');

a.add('r8 tamb8 tamb4 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"[" |');
a.add('r4 tamb4 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"/" |');
a.add('r8 tamb8 r8 tamb8 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"]" |');
a.add('r4 tamb8 tamb8 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"^" |');
a.add('r8 tamb8 tamb8 tamb8 tamb8 tamb8 r8 tamb8 r8 tamb8 ^"_" |');
a.add('r4 r4 r4 tamb8 tamb8 r8 tamb8 ^"`" |');

a.add('r8 tamb8 r4 r4  tamb8 tamb8 r8 tamb8 ^"a" |');
a.add('r4 tamb4 r4 tamb8 tamb8 r8 tamb8 ^"b" |');
a.add('r8 tamb8 tamb4 r4 tamb8 tamb8 r8 tamb8 ^"c" |');
a.add('r4 r8 tamb8 r4 tamb8 tamb8  r8 tamb8 ^"d" |');
a.add('r8 tamb8 r8 tamb8 r4  tamb8 tamb8 r8 tamb8 ^"e" |');
a.add('r4 tamb8 tamb8 r4  tamb8 tamb8 r8 tamb8 ^"f" |');
a.add('r8 tamb8 tamb8 tamb8  r4 tamb8 tamb8 r8 tamb8 ^"g" |');
a.add('r4 r4 tamb4 tamb8 tamb8 r8 tamb8 ^"h" |');
a.add('r8 tamb8 r4 tamb4 tamb8 tamb8 r8 tamb8 ^"i" |');
a.add('r4 tamb4 tamb4 tamb8 tamb8 r8 tamb8 ^"j" |');
a.add('r8 tamb8 tamb8 r8 tamb4 tamb8 tamb8 r8 tamb8 ^"k" |');
a.add('r4 r8 tamb8 tamb4 tamb8 tamb8 r8 tamb8 ^"l" |');
a.add('r8 tamb8 r8 tamb8 tamb8 r8 tamb8 tamb8 r8 tamb8 ^"m" |');
a.add('r4 tamb8 tamb8 tamb4 tamb8 tamb8 r8 tamb8 ^"n" |');
a.add('r8 tamb8 tamb8 tamb8 tamb4 tamb8 tamb8 r8 tamb8 ^"o" |');
a.add('r4 r4 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"p" |');
a.add('r8 tamb8 r4 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"q" |');										        a.add('r4 tamb4 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"r" |');
a.add('r8 tamb8 tamb4 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"s" |');
a.add('r4 r8 tamb8 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"t" |');
a.add('r8 tamb8 r8 tamb8 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"u" |');
a.add('r4 tamb8 tamb8 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"v" |');
a.add('r8 tamb8 tamb8 tamb8 r8 tamb8 tamb8 tamb8 r8 tamb8 ^"w" |');
a.add('r4 r4 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"x" |');
a.add('r8 tamb8 r4 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"y" |');
a.add('r4 tamb8 r8 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"z" |');

a.add('r8 tamb8 tamb4 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"{" |');
a.add('r4 r8 tamb8 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"|" |');
a.add('r8 tamb8 r8 tamb8 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"}" |');
a.add('r4 tamb8 tamb8 tamb8 tamb8 tamb8 tamb8 r8 tamb8 ^"~" |');
a.add('r4 r4 r4 r4 tamb8 tamb8 ^"DEL" |');

)


// Next we create an array of the text we want to process into a score.
~text = "hello world";


~text = "       *      =         ~ ~ ~ ~    *      ~       ^  ~   ~   ~ ~ ~ ~    abc abc";
~text = "HI R U OK? Where is this????       1'   !!!     **   The what???                 a machine??  123456789123456789";
~text = "who is dancing? ^ ^ ^ ~  ~   *    play  speak play  ^ speak  blood   silicon  time    TOO LATE NOW  123123"


// now run this and make sure to set the file path to a useable location
(
var f;
f = File("/Users/simon/Desktop/text.txt".standardizePath,"w");
for (0, (~text.size-1), {arg i, g;
	f.write(a[~text.at(i).ascii.asInteger], Char.nl);
}
);
f.close;
)

// This should have created a text file with lilypond notation
// Now you need to copy this into a suitable lilypond template and render the pdf




// Here is an example of something a bit more generative.
// the function generates all the ASCII charachters.
(
var f;
f = File("/Users/simon/Desktop/all3.txt".standardizePath,"w");
for (0, (95), {arg i, g;

	g=i+32;
	f.write(a[g], Char.nl);
}
);
f.close;
)

