#include <MIDI.h>

#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#include "pitches.h"
#//include "string.h"
#include <Metro.h> 
Metro serialMetro = Metro(21);  //

// If using software SPI (the default case):
#define OLED_MOSI   9
#define OLED_CLK   10
#define OLED_DC    11
#define OLED_CS    12
#define OLED_RESET 13
Adafruit_SSD1306 display(OLED_MOSI, OLED_CLK, OLED_DC, OLED_RESET, OLED_CS);


#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2

#define LOGO16_GLCD_HEIGHT 16 
#define LOGO16_GLCD_WIDTH  16 

#if (SSD1306_LCDHEIGHT != 64)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif


// midi taking it out as working without library 
// seems to be easier for handling start,stop etc.

//MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI);
//const int channel = 1;

// midi slave variables

//byte midi_noteOn =  0x90;

byte midi_noteOn =  144;
byte midi_noteOff = 0x80;
byte midi_start = 0xfa;
byte midi_stop = 0xfc;
byte midi_clock = 0xf8;
byte midi_continue = 0xfb;
int play_flag = 0;
byte commandByte;
byte noteByte;
byte velocityByte;



byte midiCommand;



// set pin numbers:
const int ledPin =  13;      // the number of the LED pin

const int soundPin = 2;

const int clickPin = 8;



// Variables will change:
int ledState = LOW;             // ledState used to set the LED
//  long previousMillis = 0;        // will store last time LED was updated

// the follow variables is a long because the time, measured in miliseconds,
// will quickly become a bigger number than can be stored in an int.
// long interval = 24;           // interval at which to blink (milliseconds)

int cursorPos = 4;



long bpm = 60;
//long tempo = 1000/(bpm/60);
long tempo = 41667;
long previousMillis = 0;
long interval = tempo;    //interval is the number of milliseconds defined by tempo formula.


int digPos = 1;
int bytePos = 0;
int letterPos = 0;

// a bool to stop the speaker clicking more than it needs.
bool clicked = false;

bool midiCheck = false;

bool timeResetActive = false;


int myData[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

char byteBuffer[10];
char charBuffer[10] = "";
String typeStr = "";
//typeStr = "";

int processResult = 0;
int soundState = 0; 
//int led = 8;



void setup()   {

  // pinMode(led, OUTPUT);

  //Serial.begin(9600);
 // Serial.begin(9600);
Serial1.begin(31250);
 // Serial.begin(9600);
delay (500);


  // by default, we'll generate the high voltage from the 3.3v line internally! (neat!)
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3C (for the 128x32)
  // init done


 pinMode(soundPin, INPUT); 

/*
  MIDI.setHandleNoteOn(handleNoteOn);  // Put only the name of the function

  // Do the same for NoteOffs
  MIDI.setHandleNoteOff(handleNoteOff);

  // Initiate MIDI communications, listen to all channels
  MIDI.begin(MIDI_CHANNEL_OMNI);

  */

  pinMode(ledPin, OUTPUT);
  pinMode(clickPin, OUTPUT);


   display.clearDisplay();
    display.setTextSize(2);
    display.setTextColor(WHITE);
    display.setCursor(4, 0);
    //  display.println("123456789123");
    display.println("no midi");
display.display();

    

}




void loop() {



if(Serial1.available() > 0) {
 // digitalWrite(ledPin, HIGH);
commandByte = Serial1.read();//read first byte



if(commandByte == midi_clock) {
Sync();
 //digitalWrite(ledPin, LOW);
}


// Well afraid I have not sorted 3 bytes :)

/*
while (Serial1.available() >= 3)//when three bytes available
   {
     if (Serial1.available())
     {
       commandByte = Serial1.read();//read first byte
       noteByte = Serial1.read();//read next byte
       velocityByte = Serial1.read();//read final byte
     }
   }

*/

 midiCommand = commandByte & B11110000;

if (commandByte == midi_noteOn) {


myData[bytePos] = 1;
sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
updateDisplay();

if (midiCommand == midi_noteOff) {
  myData[bytePos] = 0;
}



}

/*

if (midiCommand == midi_noteOff) {
  //myData[bytePos] = 0;
}

*/

if (commandByte == midi_start) {

  startAll();
}




}




while(timeResetActive == true){
  for(int i = 0; i < 10; i++){
        myData[i] = 1;}
    sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
  
  
 // MIDI.read();



 
  updateDisplay();
}



/*
if (serialMetro.check() == 1) 


{
    // save the last time you blinked the LED    previousMillis = currentMillis;

    // if the LED is off turn it on and vice-versa:
    //if (ledState == LOW)
    {
      //cursorPos = cursorPos+1;
     // ledState = HIGH;
      cursorPos = cursorPos + 1;
      digPos++;

      //updateDisplay();
    }
   // else
   //   ledState = LOW;

    // set the LED with the ledState of the variable:
    // digitalWrite(ledPin, ledState);

  }
*/

// reset line position display
  if (cursorPos == 124)
  {
    cursorPos = 4;
  }


// 

  
// reset byte pos print the character here too :)
  if (bytePos == 10)
  {
    bytePos = 0;

    
    
    //updateDisplay();

    if (myData[0] == 0 && myData[9] == 1){
    processResult = ((myData[1]*1) + (myData[2]*2) + (myData[3]*4) + (myData[4]*8) + (myData[5]*16) + (myData[6]*32) + (myData[7]*64) + (myData[8]*128));
    //void updateDisplay();

    //

  




if (processResult == 4)
{
  charBuffer[letterPos] = ' ';
    letterPos++;
 //Keyboard.print("a");
  //  Keyboard.print (" ");


//
    if (letterPos == 9)
{
  for(int i = 0; i < 10; i++){
        charBuffer[i] = 0;
        letterPos = 0;
}

charBuffer[letterPos] = (char)processResult;

       
    }

    
}






// clear text with return character

if (processResult == 13)
{ 
  letterPos = 0;
for(int i = 0; i < 9; i++){
        charBuffer[i] = 0;}
        
        }


    

if (processResult > 31 &&  processResult < 128)
{
      
    MIDImessageOUT(144, processResult, 100);//turn note on
   
    
    charBuffer[letterPos] = (char)processResult;
    letterPos++;
 //Keyboard.print("a");
//   Keyboard.print((char)processResult);


    // one

    if (letterPos > 9)
{
  for(int i = 0; i < 10; i++){
        charBuffer[i] = 0;
        letterPos = 0;
}

charBuffer[0] = (char)processResult;
letterPos++;
       
    }
    }

    }
    // clear display every time

        for(int i = 0; i < 10; i++){
        myData[i] = 0;}
    sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
    
    

    }



  
   
       

    

     
    /// clever stuff here
    
  
  
if (digPos == 13)
  {
    digPos = 1;
    // move to next digit
    bytePos++;
  }








  if (digPos == 6 && clicked == false)
  {
    // everything is happening here :)
    
    clicked = true;

    // lets take the int array and put it into a string
    if((bytePos & 1) == 0)
    {
      if(bytePos == 0)
      {
       tone(clickPin, NOTE_C7, 3);
      }
      else
      {
      tone(clickPin, NOTE_C5, 3);
      }

       digitalWrite(clickPin, LOW);
    }


    
    //sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);

   // updateDisplay();
   }

   

  if (digPos == 7)
  {
    clicked = false;
    updateDisplay();
  }


if (digPos == 4)
{
  midiCheck = true;
  //updateDisplay();
}

if (digPos == 8)
{
  midiCheck = false;
   //
   //Serial.println("n");
   
   //updateDisplay();
}


if (midiCheck == true)

  {

    
//Serial.println("f");
//MIDI.read();
//soundCheck();

}


}











void soundCheck()
{
  soundState = digitalRead(soundPin);
  if (soundState == 0){
  myData[bytePos] = 1;
  sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
  soundState = 1;
  }
}





void handleNoteOn(byte channel, byte pitch, byte velocity)
{



//if (pitch != 42 || pitch != 44 || pitch != 46)

if (pitch != 60)
{
myData[bytePos] = 0;
sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
//updateDisplay();

}








}




void handleNoteOff(byte channel, byte pitch, byte velocity)
{

  myData[bytePos] = 0;
  /*

  if (pitch == 21)
{
// finally leave the loop

 for(int i = 0; i < 10; i++){
        myData[i] = 0;}
    sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);
digPos = 1;
bytePos = 0;
letterPos = 0;
cursorPos = 4;
processResult = 0;
soundState = 0; 

clicked = false;
midiCheck = false;

timeResetActive = false;

}
*/
  
}




void updateDisplay()
{
  

    display.clearDisplay();
    display.setTextSize(2);
    display.setTextColor(WHITE);
    display.setCursor(4, 0);
    display.println(byteBuffer);
    display.setCursor(4, 25);
    display.println(charBuffer);
    //display.println("1000");
 // display.println("1000");
    display.drawLine(cursorPos, 15, cursorPos, 0, WHITE);


   // display.drawPixel(0, 0, WHITE);
   // display.drawPixel(127, 0, WHITE);
    display.display();
  
}





void Sync() {
// do something for every MIDI Clock pulse when the sequencer is running
      cursorPos = cursorPos + 1;
      digPos++;
} 






void startAll()

{

// clear data
  for(int i = 0; i < 10; i++){
        myData[i] = 0;}
    sprintf(byteBuffer, "%01d%01d%01d%01d%01d%01d%01d%01d%01d%01d", myData[0], myData[1], myData[2], myData[3], myData[4], myData[5], myData[6], myData[7], myData[8], myData[9]);

cursorPos = 4;
digPos = 1;
bytePos = 0;
letterPos = 0;
for(int i = 0; i < 9; i++){
        charBuffer[i] = 0;}


}



void MIDImessageOUT(int command, int MIDInote, int MIDIvelocity) {
  Serial1.write(command);//send note on or note off command 
  Serial1.write(MIDInote);//send pitch data
  Serial1.write(MIDIvelocity);//send velocity data
}





